/** @file   MUsableObject.h
 * @brief   Declaration of MUsableObject interface.
 * @version $Revision: 1.2 $
 * @date    $Date: 2006/05/15 19:20:39 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_MUSABLE_H
#define H_WWW_MUSABLE_H


namespace WeWantWar {

/** @class  MUsableObject
 * @brief   Defines the interface for objects that can be activated by the
 *          player.
 * @author  Tomi Lamminsaari
 *
 * Every object that can be activated by another GameObject must implement
 * this interface. For instance, a machine that activates when player presses
 * a USE-key must use this interface.
 */
class MUsableObject
{
public:
  /** The states the MUsableObject can be in.
   */
  enum State {
    /** Object is ready to be activated. */
    EReady,
    /** Object is currently starting up after activation. */
    EStarting,
    /** Object is active. */
    EActive,
    /** Object has been deactivated and it's stopping. */
    EStopping,
    /** Object is passive and it cannot be activated. */
    EPassive
  };
  
  virtual ~MUsableObject() { }
  
  /** Activates this object. 
   * @param   aActor            The GameObject who activated us.
   * @return  0 if no problems.
   */
  virtual int doActivate( GameObject* aActor ) = 0;
  
  /** Tells the state of this object.
   * @return  Current state.
   */
  virtual State currentState() const = 0;
};

};  // end of namespace

#endif
